/* ###################################################################
**     This component module is generated by Processor Expert. Do not modify it.
**     Filename    : pin_mux.c
**     Project     : FRDM-K64F
**     Processor   : MK64FN1M0VLL12
**     Component   : PinSettings
**     Version     : Component 1.2.0, Driver 1.4, CPU db: 3.00.000
**     Repository  : KSDK 1.3.0
**     Compiler    : GNU C Compiler
**
**     Copyright : 1997 - 2015 Freescale Semiconductor, Inc.
**     All Rights Reserved.
**
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**     http: www.freescale.com
**     mail: support@freescale.com
** ###################################################################*/
/*!
** @file pin_mux.c
** @version 1.4
** @brief
**
*/
/*!
**  @addtogroup pin_mux_module pin_mux module documentation
**  @{
*/

/* MODULE pin_mux. */

#include "fsl_device_registers.h"
#include "fsl_port_hal.h"
#include "fsl_sim_hal.h"
#include "pin_mux.h"

void configure_can_pins(uint32_t instance)
{
  /* PORTB_PCR19 */
  PORT_HAL_SetMuxMode(PORTB,19u,kPortMuxAlt2);
  /* PORTB_PCR18 */
  PORT_HAL_SetMuxMode(PORTB,18u,kPortMuxAlt2);
}

void configure_cmp_pins(uint32_t instance)
{
  switch(instance) {
    case CMP0_IDX:
      PORT_HAL_SetMuxMode(PORTC,6u,kPortPinDisabled);  /* CMP0_IN0 */
      break;
    case CMP1_IDX:
      PORT_HAL_SetMuxMode(PORTC,3u, kPortPinDisabled); /* PTC3 - CMP1_IN1. */
      break;
    default:
      break;
  }
}

void configure_enet_pins(uint32_t instance)
{
  /* Affects PORTC_PCR16 register */
  PORT_HAL_SetMuxMode(PORTC,16u,kPortMuxAlt4);
  /* Affects PORTC_PCR17 register */
  PORT_HAL_SetMuxMode(PORTC,17u,kPortMuxAlt4);
  /* Affects PORTC_PCR18 register */
  PORT_HAL_SetMuxMode(PORTC,18u,kPortMuxAlt4);
  /* Affects PORTC_PCR19 register */
  PORT_HAL_SetMuxMode(PORTC,19u,kPortMuxAlt4);
  /* Affects PORTB_PCR1 register */
  PORT_HAL_SetMuxMode(PORTB,1u,kPortMuxAlt4);
  /* Affects PORTB_PCR0 register */
  PORT_HAL_SetMuxMode(PORTB,0u,kPortMuxAlt4);
  PORT_HAL_SetOpenDrainCmd(PORTB,0u,true);
  PORT_HAL_SetPullMode(PORTB,0u,kPortPullUp);
  PORT_HAL_SetPullCmd(PORTB,0u,true);
  /* Affects PORTA_PCR13 register */
  PORT_HAL_SetMuxMode(PORTA,13u,kPortMuxAlt4);
  /* Affects PORTA_PCR12 register */
  PORT_HAL_SetMuxMode(PORTA,12u,kPortMuxAlt4);
  /* Affects PORTA_PCR14 register */
  PORT_HAL_SetMuxMode(PORTA,14u,kPortMuxAlt4);
  /* Affects PORTA_PCR5 register */
  PORT_HAL_SetMuxMode(PORTA,5u,kPortMuxAlt4);
  /* Affects PORTA_PCR16 register */
  PORT_HAL_SetMuxMode(PORTA,16u,kPortMuxAlt4);
  /* Affects PORTA_PCR17 register */
  PORT_HAL_SetMuxMode(PORTA,17u,kPortMuxAlt4);
  /* Affects PORTA_PCR15 register */
  PORT_HAL_SetMuxMode(PORTA,15u,kPortMuxAlt4);
  /* Affects PORTA_PCR28 register */
  PORT_HAL_SetMuxMode(PORTA,28u,kPortMuxAlt4);
}

void configure_gpio_pins(uint32_t instance)
{
  switch(instance) {
    case PORTA_IDX:                      /* PORTA_IDX */
      /* Affects PORTA_PCR4 register */
      PORT_HAL_SetPassiveFilterCmd(PORTA,4u,false);
      PORT_HAL_SetMuxMode(PORTA,4u,kPortMuxAsGpio);
      PORT_HAL_SetPullMode(PORTA,4u,kPortPullUp);
      PORT_HAL_SetPullCmd(PORTA,4u,true);
      break;
    case PORTB_IDX:                      /* PORTB_IDX */
      /* Affects PORTB_PCR21 register */
      PORT_HAL_SetDriveStrengthMode(PORTB,21u,kPortLowDriveStrength);
      PORT_HAL_SetMuxMode(PORTB,21u,kPortMuxAsGpio);
      PORT_HAL_SetSlewRateMode(PORTB,21u,kPortSlowSlewRate);
      /* Affects PORTB_PCR22 register */
      PORT_HAL_SetDriveStrengthMode(PORTB,22u,kPortLowDriveStrength);
      PORT_HAL_SetMuxMode(PORTB,22u,kPortMuxAsGpio);
      PORT_HAL_SetSlewRateMode(PORTB,22u,kPortSlowSlewRate);
      break;
    case PORTC_IDX:                      /* PORTC_IDX */
      /* Affects PORTC_PCR0 register */
      PORT_HAL_SetMuxMode(PORTC,0u,kPortMuxAsGpio);
      /* Affects PORTC_PCR6 register */
      PORT_HAL_SetPassiveFilterCmd(PORTC,6u,false);
      PORT_HAL_SetMuxMode(PORTC,6u,kPortMuxAsGpio);
      PORT_HAL_SetPullMode(PORTC,6u,kPortPullUp);
      PORT_HAL_SetPullCmd(PORTC,6u,true);
      /* Affects PORTC_PCR8 register */
      PORT_HAL_SetMuxMode(PORTC,8u,kPortMuxAsGpio);
      /* Affects PORTC_PCR9 register */
      PORT_HAL_SetMuxMode(PORTC,9u,kPortMuxAsGpio);
      /* Affects PORTC_PCR12 register */
      PORT_HAL_SetMuxMode(PORTC,12u,kPortMuxAsGpio);
      /* Affects PORTC_PCR13 register */
      PORT_HAL_SetMuxMode(PORTC,13u,kPortMuxAsGpio);
      break;
    case PORTE_IDX:                      /* PORTE_IDX */
      /* Affects PORTE_PCR6 register */
      PORT_HAL_SetMuxMode(PORTE,6u,kPortMuxAsGpio);
      /* Affects PORTE_PCR26 register */
      PORT_HAL_SetDriveStrengthMode(PORTE,26u,kPortLowDriveStrength);
      PORT_HAL_SetMuxMode(PORTE,26u,kPortMuxAsGpio);
      PORT_HAL_SetSlewRateMode(PORTE,26u,kPortSlowSlewRate);
      break;
    default:
      break;
  }
}

void configure_i2c_pins(uint32_t instance)
{
  switch(instance) {
    case I2C0_IDX:                       /* I2C0 */
      /* Affects PORTE_PCR24 register */
      PORT_HAL_SetMuxMode(PORTE,24u,kPortMuxAlt5);
      PORT_HAL_SetOpenDrainCmd(PORTE,24u,true);
      /* Affects PORTE_PCR25 register */
      PORT_HAL_SetMuxMode(PORTE,25u,kPortMuxAlt5);
      PORT_HAL_SetOpenDrainCmd(PORTE,25u,true);
      break;
    case I2C1_IDX:                       /* I2C1 */
      /* Affects PORTC_PCR10 register */
      PORT_HAL_SetMuxMode(PORTC,10u,kPortMuxAlt2);
      PORT_HAL_SetOpenDrainCmd(PORTC,10u,true);
      /* Affects PORTC_PCR11 register */
      PORT_HAL_SetMuxMode(PORTC,11u,kPortMuxAlt2);
      PORT_HAL_SetOpenDrainCmd(PORTC,11u,true);
      break;
    default:
      break;
  }
}

void configure_i2s_pins(uint32_t instance)
{
  /* Affects PORTC_PCR8 register */
  PORT_HAL_SetMuxMode(PORTC,8u,kPortMuxAlt4);
  /* Affects PORTC_PCR9 register */
  PORT_HAL_SetMuxMode(PORTC,9u,kPortMuxAlt4);
  /* Affects PORTC_PCR7 register */
  PORT_HAL_SetMuxMode(PORTC,7u,kPortMuxAlt4);
  /* Affects PORTC_PCR5 register */
  PORT_HAL_SetMuxMode(PORTC,5u,kPortMuxAlt4);
  /* Affects PORTB_PCR18 register */
  PORT_HAL_SetMuxMode(PORTB,18u,kPortMuxAlt4);
  /* Affects PORTB_PCR19 register */
  PORT_HAL_SetMuxMode(PORTB,19u,kPortMuxAlt4);
  /* Affects PORTC_PCR1 register */
  PORT_HAL_SetMuxMode(PORTC,1u,kPortMuxAlt6);
}

void configure_rtc_pins(uint32_t instance)
{
  /* Affects PORTE_PCR26 register */
  PORT_HAL_SetMuxMode(PORTE,26u,kPortMuxAlt6);
}

void configure_sdhc_pins(uint32_t instance)
{
  /* Affects PORTE_PCR3 register */
  PORT_HAL_SetMuxMode(PORTE,3u,kPortMuxAlt4);
  PORT_HAL_SetPullMode(PORTE,3u,kPortPullUp);
  PORT_HAL_SetPullCmd(PORTE,3u,true);
  PORT_HAL_SetDriveStrengthMode(PORTE,3u,kPortHighDriveStrength);
  /* Affects PORTE_PCR1 register */
  PORT_HAL_SetMuxMode(PORTE,1u,kPortMuxAlt4);
  PORT_HAL_SetPullMode(PORTE,1u,kPortPullUp);
  PORT_HAL_SetPullCmd(PORTE,1u,true);
  PORT_HAL_SetDriveStrengthMode(PORTE,1u,kPortHighDriveStrength);
  /* Affects PORTE_PCR0 register */
  PORT_HAL_SetMuxMode(PORTE,0u,kPortMuxAlt4);
  PORT_HAL_SetPullMode(PORTE,0u,kPortPullUp);
  PORT_HAL_SetPullCmd(PORTE,0u,true);
  PORT_HAL_SetDriveStrengthMode(PORTE,0u,kPortHighDriveStrength);
  /* Affects PORTE_PCR5 register */
  PORT_HAL_SetMuxMode(PORTE,5u,kPortMuxAlt4);
  PORT_HAL_SetPullMode(PORTE,5u,kPortPullUp);
  PORT_HAL_SetPullCmd(PORTE,5u,true);
  PORT_HAL_SetDriveStrengthMode(PORTE,5u,kPortHighDriveStrength);
  /* Affects PORTE_PCR4 register */
  PORT_HAL_SetMuxMode(PORTE,4u,kPortMuxAlt4);
  PORT_HAL_SetPullMode(PORTE,4u,kPortPullUp);
  PORT_HAL_SetPullCmd(PORTE,4u,true);
  PORT_HAL_SetDriveStrengthMode(PORTE,4u,kPortHighDriveStrength);
  /* Affects PORTE_PCR2 register */
  PORT_HAL_SetMuxMode(PORTE,2u,kPortMuxAlt4);
  PORT_HAL_SetPullMode(PORTE,2u,kPortPullUp);
  PORT_HAL_SetPullCmd(PORTE,2u,true);
  PORT_HAL_SetDriveStrengthMode(PORTE,2u,kPortHighDriveStrength);
}

void configure_spi_pins(uint32_t instance)
{
  switch(instance) {
    case SPI0_IDX:                       /* SPI0 */
      /* Affects PORTD_PCR0 register */
      PORT_HAL_SetMuxMode(PORTD,0u,kPortMuxAlt2);
      /* Affects PORTD_PCR3 register */
      PORT_HAL_SetMuxMode(PORTD,3u,kPortMuxAlt2);
      /* Affects PORTD_PCR1 register */
      PORT_HAL_SetMuxMode(PORTD,1u,kPortMuxAlt2);
      /* Affects PORTD_PCR2 register */
      PORT_HAL_SetMuxMode(PORTD,2u,kPortMuxAlt2);
      break;
    case SPI1_IDX:                       /* SPI1 */
      /* Affects PORTD_PCR4 register */
      PORT_HAL_SetMuxMode(PORTD,4u,kPortMuxAlt7);
      /* Affects PORTD_PCR7 register */
      PORT_HAL_SetMuxMode(PORTD,7u,kPortMuxAlt7);
      /* Affects PORTD_PCR5 register */
      PORT_HAL_SetMuxMode(PORTD,5u,kPortMuxAlt7);
      /* Affects PORTD_PCR6 register */
      PORT_HAL_SetMuxMode(PORTD,6u,kPortMuxAlt7);
      break;
    default:
      break;
  }
}

void configure_uart_pins(uint32_t instance)
{
  switch(instance) {
    case UART0_IDX:                      /* UART0 */
      /* Affects PORTB_PCR16 register */
      PORT_HAL_SetMuxMode(PORTB,16u,kPortMuxAlt3);
      /* Affects PORTB_PCR17 register */
      PORT_HAL_SetMuxMode(PORTB,17u,kPortMuxAlt3);
      break;
    case UART3_IDX:                      /* UART3 */
      /* Affects PORTC_PCR16 register */
      PORT_HAL_SetMuxMode(PORTC,16u,kPortMuxAlt3);
      /* Affects PORTC_PCR17 register */
      PORT_HAL_SetMuxMode(PORTC,17u,kPortMuxAlt3);
      break;
    case UART4_IDX:                      /* UART4 */
      /* Affects PORTC_PCR14 register */
      PORT_HAL_SetMuxMode(PORTC,14u,kPortMuxAlt3);
      /* Affects PORTC_PCR15 register */
      PORT_HAL_SetMuxMode(PORTC,15u,kPortMuxAlt3);
      break;
    default:
      break;
  }
}

void configure_ftm_pins(uint32_t instance)
{
  switch(instance) {
    case FTM0_IDX:                       /* FTM0 */
      /* Affects PORTC_PCR1 register */
      PORT_HAL_SetMuxMode(PORTC,1u,kPortMuxAlt4);
      break;
    default:
      break;
  }
}

/* END pin_mux. */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.5 [05.21]
**     for the Freescale Kinetis series of microcontrollers.
**
** ###################################################################
*/

